#ifndef _WIN32_DCOM
#define _WIN32_DCOM
#endif

#include <windows.h>
#include <objbase.h>
#include <atlbase.h>
#include <iostream>
#include <wbemidl.h>
#include <comutil.h>

#include "PingSink.h"

int main( int argc, char** argv )
{
	HRESULT hr = CoInitializeEx( NULL, COINIT_MULTITHREADED );
	if ( FAILED( hr ) )
	{
		std::cerr << "COM initialization failed" << std::endl;
		return -1;
	}

	// setup process-wide security context
	hr = CoInitializeSecurity( NULL, // we're not a server
							   -1, // we're not a server
							   NULL, // dito
							   NULL, // reserved
							   RPC_C_AUTHN_LEVEL_DEFAULT, // let DCOM decide
							   RPC_C_IMP_LEVEL_IMPERSONATE,
							   NULL,
							   EOAC_NONE,
							   NULL );
	if ( FAILED( hr ) )
	{
		std::cerr << "Security initialization failed" << std::endl;
		return -1;
	}

	int result = 0;
	// we're going to use CComPtr<>s, whose lifetime must end BEFORE CoUnitialize is called
	{
		// connect to WMI
		CComPtr< IWbemLocator > locator;
		hr = CoCreateInstance( CLSID_WbemAdministrativeLocator, NULL,
							CLSCTX_INPROC_SERVER,
							IID_IWbemLocator, reinterpret_cast< void** >( &locator ) );
		if ( FAILED( hr ) )
		{
			std::cerr << "Instantiation of IWbemLocator failed" << std::endl;
			return -1;
		}

		// connect to local service with current credentials
		CComPtr< IWbemServices > service;
		hr = locator->ConnectServer( L"root\\cimv2", NULL, NULL, NULL,
									 WBEM_FLAG_CONNECT_USE_MAX_WAIT,
									 NULL, NULL, &service );
		if ( SUCCEEDED( hr ) )
		{
			CComPtr< CPingSink > pPingSink = new CPingSink;
			// execute the query asynchrounously; result processing is done by class CPingSink
			// you might want to use a more real life IP address here:
			hr = service->ExecQueryAsync( L"WQL", L"SELECT * FROM Win32_PingStatus WHERE Address=\"127.0.0.1\"",
										  0, NULL, pPingSink );
			if ( SUCCEEDED( hr ) ) // query has been launched, wait for result
								   // of course, the polling done here is rather crude; there might be more 
								   // usefull stuff to do
			{
				std::cout << "Waiting... " << std::endl;
				while ( pPingSink->m_inProgress ) Sleep( 500 );
				std::cout << "Host is " << ( pPingSink->m_isReachable ? "" : "not " ) << "reachable" << std::endl;
			}
			else
			{
				std::cerr << "Query failed" << std::endl;
				result = -1;
			}
		}
		else
		{
			std::cerr << "Couldn't connect to service" << std::endl;
			result = -1;
		}
	}
	CoUninitialize();

	return result;
}
